/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.SlaveResourceService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SlaveResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 5205195140557748211L;
    private final SlaveResourceService service;
    private static final Pattern PATHWITHOUTID = Pattern.compile("/.*?(/.*)$");

    public SlaveResourceServlet(SlaveResourceService service) {
        this.service = service;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.service(req.getPathInfo(), resp.getOutputStream());
    }

    public void service(String pathInfo, OutputStream out) throws IOException {
        try {
            this.service.serve(SlaveResourceServlet.stripId(pathInfo), out);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    public static String stripId(String path) {
        Matcher match = PATHWITHOUTID.matcher(path);
        if (match.find()) {
            return match.group(1);
        }
        throw new IllegalArgumentException(path);
    }
}

