/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.Time;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.joda.time.Instant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveBrowser {
    public static final long TIMEOUT = 15000L;
    private static final int POLL_RESPONSE_TIMEOUT = 2;
    private final Time time;
    private final String id;
    private final BrowserInfo browserInfo;
    private final BlockingQueue<Command> commandsToRun = new LinkedBlockingQueue<Command>();
    private long dequeueTimeout = 10L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private volatile Instant lastHeartBeat;
    private Set<FileInfo> fileSet = new LinkedHashSet<FileInfo>();
    private final BlockingQueue<CommandResponse> responses = new LinkedBlockingQueue<CommandResponse>();
    private Command commandRunning = null;
    private Command lastCommandDequeued;
    private final long timeout;

    public SlaveBrowser(Time time, String id, BrowserInfo browserInfo, long timeout) {
        this.time = time;
        this.timeout = timeout;
        this.lastHeartBeat = time.now();
        this.id = id;
        this.browserInfo = browserInfo;
    }

    public String getId() {
        return this.id;
    }

    public void createCommand(String data) {
        try {
            this.commandsToRun.put(new Command(data));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Command dequeueCommand() {
        try {
            Command command = this.commandsToRun.poll(this.dequeueTimeout, this.timeUnit);
            if (command != null) {
                this.commandRunning = command;
                this.lastCommandDequeued = command;
            }
            return command;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public Command getLastDequeuedCommand() {
        return this.lastCommandDequeued;
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setDequeueTimeout(long dequeueTimeout, TimeUnit timeUnit) {
        this.dequeueTimeout = dequeueTimeout;
        this.timeUnit = timeUnit;
    }

    public void heartBeat() {
        this.lastHeartBeat = this.time.now();
    }

    public Instant getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public void addFiles(Collection<FileInfo> fileSet) {
        this.fileSet.removeAll(fileSet);
        this.fileSet.addAll(fileSet);
    }

    public Set<FileInfo> getFileSet() {
        return this.fileSet;
    }

    public synchronized void resetFileSet() {
        this.fileSet.clear();
    }

    public CommandResponse getResponse() {
        try {
            return this.responses.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public synchronized void addResponse(Response response, boolean isLast) {
        if (isLast) {
            this.commandRunning = null;
        }
        this.responses.offer(new CommandResponse(response, isLast));
    }

    public void clearResponseQueue() {
        this.responses.clear();
    }

    public boolean isCommandRunning() {
        return this.commandRunning != null;
    }

    public synchronized Command getCommandRunning() {
        return this.commandRunning;
    }

    public synchronized void removeFiles(Collection<FileSource> errorFiles) {
        LinkedHashSet<FileInfo> filesInfoToRemove = new LinkedHashSet<FileInfo>();
        block0: for (FileSource f : errorFiles) {
            for (FileInfo info : this.fileSet) {
                if (!info.getFileName().equals(f.getBasePath())) continue;
                filesInfoToRemove.add(info);
                continue block0;
            }
        }
        this.fileSet.removeAll(filesInfoToRemove);
    }

    public Command peekCommand() {
        return (Command)this.commandsToRun.peek();
    }

    public void clearCommandRunning() {
        if (this.commandRunning != null) {
            this.commandRunning = null;
            this.commandsToRun.clear();
            this.responses.clear();
        }
    }

    public boolean isAlive() {
        return this.time.now().getMillis() - this.lastHeartBeat.getMillis() < this.timeout;
    }

    public String toString() {
        return String.format("SlaveBrowser(browserInfo=%s,\nid=%s,\nsinceLastCheck=%s)", this.browserInfo, this.id, this.time.now().getMillis() - this.lastHeartBeat.getMillis());
    }

    public static class CommandResponse {
        private Response response;
        private final boolean last;

        public CommandResponse(Response response, boolean last) {
            this.response = response;
            this.last = last;
        }

        public Response getResponse() {
            return this.response;
        }

        public boolean isLast() {
            return this.last;
        }

        public void setResponse(Response response) {
            this.response = response;
        }
    }
}

