/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.ObservableAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStartupAction
implements ObservableAction {
    private static final Logger logger = LoggerFactory.getLogger(ServerStartupAction.class);
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache preloadedFilesCache;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private JsTestDriverServer server;
    private List<Observer> observerList = new LinkedList<Observer>();
    private final long browserTimeout;

    @Deprecated
    public ServerStartupAction(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, URLTranslator urlTranslator, URLRewriter urlRewriter) {
        this(port, capturedBrowsers, preloadedFilesCache, urlTranslator, urlRewriter, 15000L);
    }

    public ServerStartupAction(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, URLTranslator urlTranslator, URLRewriter urlRewriter, long browserTimeout) {
        this.port = port;
        this.capturedBrowsers = capturedBrowsers;
        this.preloadedFilesCache = preloadedFilesCache;
        this.urlTranslator = urlTranslator;
        this.urlRewriter = urlRewriter;
        this.browserTimeout = browserTimeout;
    }

    public JsTestDriverServer getServer() {
        return this.server;
    }

    @Override
    public void run() {
        logger.info("Starting server...");
        this.server = new JsTestDriverServer(this.port, this.capturedBrowsers, this.preloadedFilesCache, this.urlTranslator, this.urlRewriter, this.browserTimeout);
        for (Observer o : this.observerList) {
            this.server.addObserver(o);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting the server on " + this.port, e);
        }
    }

    @Override
    public void addObservers(List<Observer> observers) {
        this.observerList.addAll(observers);
    }
}

