/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.output.TestResultListener;
import java.util.Collection;

public class RunTestsActionResponseStream
implements ResponseStream {
    private final TestResultGenerator testResultGenerator;
    private final TestResultListener listener;
    private final FailureAccumulator accumulator;
    private final Gson gson = new Gson();

    public RunTestsActionResponseStream(TestResultGenerator testResultGenerator, TestResultListener listener, FailureAccumulator accumulator) {
        this.testResultGenerator = testResultGenerator;
        this.listener = listener;
        this.accumulator = accumulator;
    }

    public void stream(Response response) {
        switch (response.getResponseType()) {
            case TEST_RESULT: {
                Collection<TestResult> testResults = this.testResultGenerator.getTestResults(response);
                for (TestResult result : testResults) {
                    if (result.getResult() == TestResult.Result.failed || result.getResult() == TestResult.Result.error) {
                        this.accumulator.add();
                    }
                    this.listener.onTestComplete(result);
                }
                break;
            }
            case FILE_LOAD_RESULT: {
                LoadedFiles files = (LoadedFiles)this.gson.fromJson(response.getResponse(), response.getGsonType());
                for (FileResult result : files.getLoadedFiles()) {
                    if (!result.isSuccess()) {
                        this.accumulator.add();
                    }
                    this.listener.onFileLoad(response.getBrowser().toString(), result);
                }
                break;
            }
        }
    }

    public void finish() {
        this.listener.finish();
    }
}

