/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileReader;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.hooks.FileLoadPostProcessor;
import com.google.jstestdriver.hooks.FileLoadPreProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingFileLoader
implements FileLoader {
    private final JsTestDriverFileFilter filter;
    private final FileReader reader;
    private final Set<FileLoadPostProcessor> postprocessors;
    private final Set<FileLoadPreProcessor> preProcessors;

    @Inject
    public ProcessingFileLoader(JsTestDriverFileFilter filter, FileReader reader, Set<FileLoadPostProcessor> postprocessors, Set<FileLoadPreProcessor> preProcessors) {
        this.filter = filter;
        this.reader = reader;
        this.postprocessors = postprocessors;
        this.preProcessors = preProcessors;
    }

    @Override
    public List<FileInfo> loadFiles(Collection<FileInfo> filesToLoad, boolean shouldReset) {
        LinkedList<FileInfo> loadedFiles = new LinkedList<FileInfo>();
        try {
            for (FileInfo file : this.preProcessFiles(filesToLoad)) {
                FileInfo processed = this.loadFile(shouldReset, file);
                processed = this.postProcessFile(processed);
                loadedFiles.add(processed);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        return loadedFiles;
    }

    private FileInfo loadFile(boolean shouldReset, FileInfo file) {
        if (!file.canLoad()) {
            return file;
        }
        StringBuilder fileContent = new StringBuilder();
        long timestamp = file.getTimestamp();
        fileContent.append(this.filter.filterFile(this.reader.readFile(file.getFileName()), !shouldReset));
        List<FileInfo> patches = file.getPatches();
        if (patches != null) {
            for (FileInfo patch : patches) {
                fileContent.append(this.reader.readFile(patch.getFileName()));
            }
        }
        return new FileInfo(file.getFileName(), timestamp, false, file.isServeOnly(), fileContent.toString());
    }

    private FileInfo postProcessFile(FileInfo processed) {
        for (FileLoadPostProcessor hook : this.postprocessors) {
            processed = hook.process(processed);
        }
        return processed;
    }

    private List<FileInfo> preProcessFiles(Collection<FileInfo> filesToLoad) {
        List<FileInfo> files = new LinkedList<FileInfo>(filesToLoad);
        for (FileLoadPreProcessor processor : this.preProcessors) {
            files = processor.process(files);
        }
        return files;
    }
}

