/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathRewriter;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.oro.io.GlobFilenameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolver {
    private final PathRewriter pathRewriter;
    private final Set<FileParsePostProcessor> processors;
    private final File basePath;

    @Inject
    public PathResolver(@Named(value="basePath") File basePath, PathRewriter pathRewriter, Set<FileParsePostProcessor> processors) {
        this.basePath = basePath;
        this.pathRewriter = pathRewriter;
        this.processors = processors;
    }

    public String resolvePath(String path) {
        String[] tokenizedPath;
        Stack<String> resolvedPath = new Stack<String>();
        for (String token : tokenizedPath = path.split("/")) {
            if (token.equals("..") && !resolvedPath.isEmpty()) {
                resolvedPath.pop();
                continue;
            }
            resolvedPath.push(token);
        }
        return this.join(resolvedPath);
    }

    private String join(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append("/");
                sb.append(iterator.next());
            }
        }
        return sb.toString();
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> resolvedFilesLoad) {
        LinkedHashSet<FileInfo> consolidated = new LinkedHashSet<FileInfo>(resolvedFilesLoad.size());
        FileInfo currentNonPatch = null;
        for (FileInfo fileInfo : resolvedFilesLoad) {
            if (fileInfo.isPatch()) {
                if (currentNonPatch == null) {
                    throw new IllegalStateException("Patch " + fileInfo + " without a core file to patch");
                }
                currentNonPatch.addPatch(fileInfo);
                continue;
            }
            consolidated.add(fileInfo);
            currentNonPatch = fileInfo;
        }
        return consolidated;
    }

    public Set<FileInfo> resolve(Set<FileInfo> unResolvedFiles) {
        Set<FileInfo> resolvedFiles = new LinkedHashSet<FileInfo>();
        for (FileInfo fileInfo : unResolvedFiles) {
            String pattern;
            String f = fileInfo.getFileName();
            if ((f = this.pathRewriter.rewrite(f)).startsWith("http://") || f.startsWith("https://")) {
                resolvedFiles.add(new FileInfo(f, -1L, false, false, null));
                continue;
            }
            File file = this.basePath != null ? new File(this.basePath.getAbsoluteFile(), f) : new File(f);
            File testFile = file.getAbsoluteFile();
            File dir = testFile.getParentFile().getAbsoluteFile();
            String[] filteredFiles = dir.list(new GlobFilenameFilter(pattern = file.getName(), 1));
            if (filteredFiles == null || filteredFiles.length == 0) {
                try {
                    String error = "The patterns/paths " + f + " (" + dir + ") " + " used in the configuration" + " file didn't match any file, the files patterns/paths need to" + " be relative " + this.basePath.getCanonicalPath();
                    throw new RuntimeException(error);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Arrays.sort(filteredFiles, String.CASE_INSENSITIVE_ORDER);
            for (String filteredFile : filteredFiles) {
                String resolvedFilePath = this.resolvePath(dir.getAbsolutePath().replaceAll("\\\\", "/") + "/" + filteredFile.replaceAll("\\\\", "/"));
                File resolvedFile = new File(resolvedFilePath);
                resolvedFiles.add(new FileInfo(resolvedFilePath, resolvedFile.lastModified(), fileInfo.isPatch(), fileInfo.isServeOnly(), null));
            }
        }
        for (FileParsePostProcessor processor : this.processors) {
            resolvedFiles = processor.process(resolvedFiles);
        }
        return this.consolidatePatches(resolvedFiles);
    }

    public List<Plugin> resolve(List<Plugin> plugins) {
        LinkedList<Plugin> resolved = Lists.newLinkedList();
        for (Plugin plugin : plugins) {
            resolved.add(plugin.getPluginFromPath(this.resolvePath(plugin.getPathToJar())));
        }
        return resolved;
    }
}

