/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserHunter;
import com.google.jstestdriver.BrowserQueryResponseServlet;
import com.google.jstestdriver.CaptureServlet;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.CommandServlet;
import com.google.jstestdriver.FileCacheServlet;
import com.google.jstestdriver.FileSetServlet;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.ForwardingServlet;
import com.google.jstestdriver.HeartbeatServlet;
import com.google.jstestdriver.HelloServlet;
import com.google.jstestdriver.HomeServlet;
import com.google.jstestdriver.SlaveResourceService;
import com.google.jstestdriver.SlaveResourceServlet;
import com.google.jstestdriver.StandaloneRunnerFilesFilterImpl;
import com.google.jstestdriver.StandaloneRunnerServlet;
import com.google.jstestdriver.TestResourceServlet;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.browser.BrowserReaper;
import com.google.jstestdriver.servlet.BrowserLoggingServlet;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsTestDriverServer
extends Observable {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriverServer.class);
    private final Server server = new Server();
    private final int port;
    private final CapturedBrowsers capturedBrowsers;
    private final FilesCache filesCache;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private Context context;
    private final long browserTimeout;
    private Timer timer;

    public JsTestDriverServer(int port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, URLTranslator urlTranslator, URLRewriter urlRewriter, long browserTimeout) {
        this.port = port;
        this.capturedBrowsers = capturedBrowsers;
        this.filesCache = preloadedFilesCache;
        this.urlTranslator = urlTranslator;
        this.urlRewriter = urlRewriter;
        this.browserTimeout = browserTimeout;
        this.initJetty(this.port);
        this.initServlets();
    }

    private void initServlets() {
        ForwardingMapper forwardingMapper = new ForwardingMapper();
        this.addServlet("/", new HomeServlet(this.capturedBrowsers));
        this.addServlet("/hello", new HelloServlet());
        this.addServlet("/heartbeat", new HeartbeatServlet(this.capturedBrowsers));
        this.addServlet("/capture", new CaptureServlet(new BrowserHunter(this.capturedBrowsers, this.browserTimeout)));
        this.addServlet("/runner/*", new StandaloneRunnerServlet(new BrowserHunter(this.capturedBrowsers, this.browserTimeout), this.filesCache, new StandaloneRunnerFilesFilterImpl(), new SlaveResourceService("/com/google/jstestdriver/javascript")));
        this.addServlet("/slave/*", new SlaveResourceServlet(new SlaveResourceService("/com/google/jstestdriver/javascript")));
        this.addServlet("/cmd", new CommandServlet(this.capturedBrowsers, this.urlTranslator, this.urlRewriter, forwardingMapper));
        this.addServlet("/query/*", new BrowserQueryResponseServlet(this.capturedBrowsers, this.urlTranslator, forwardingMapper));
        this.addServlet("/fileSet", new FileSetServlet(this.capturedBrowsers, this.filesCache));
        this.addServlet("/cache", new FileCacheServlet());
        this.addServlet("/log", new BrowserLoggingServlet());
        this.addServlet("/test/*", new TestResourceServlet(this.filesCache));
        this.addServlet("/forward/*", new ForwardingServlet(forwardingMapper, "localhost", this.port));
    }

    private void addServlet(String url, Servlet servlet) {
        this.context.addServlet(new ServletHolder(servlet), url);
    }

    private void initJetty(int port) {
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        this.server.addConnector(connector);
        this.context = new Context(this.server, "/", 1);
        this.context.setMaxFormContentSize(Integer.MAX_VALUE);
    }

    public void start() {
        try {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new BrowserReaper(this.capturedBrowsers), 3000L, 3000L);
            this.server.start();
            this.setChanged();
            this.notifyObservers((Object)Event.STARTED);
            logger.debug("Starting the server.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.timer.cancel();
            this.server.stop();
            this.setChanged();
            this.notifyObservers((Object)Event.STOPPED);
            logger.debug("Stopped the server.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        STARTED,
        STOPPED;

    }
}

