/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CommandTask;
import com.google.jstestdriver.CommandTaskFactory;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JsTestDriverClientImpl
implements JsTestDriverClient {
    private final Gson gson = new Gson();
    private final CommandTaskFactory commandTaskFactory;
    private final Set<FileInfo> fileSet;
    private final String baseUrl;
    private final Server server;
    private final Boolean debug;

    @Inject
    public JsTestDriverClientImpl(CommandTaskFactory commandTaskFactory, @Named(value="fileSet") Set<FileInfo> fileSet, @Named(value="server") String baseUrl, Server server, @Named(value="debug") Boolean debug) {
        this.commandTaskFactory = commandTaskFactory;
        this.fileSet = fileSet;
        this.baseUrl = baseUrl;
        this.server = server;
        this.debug = debug;
    }

    @Override
    public Collection<BrowserInfo> listBrowsers() {
        return (Collection)this.gson.fromJson(this.server.fetch(this.baseUrl + "/cmd?listBrowsers"), new TypeToken<Collection<BrowserInfo>>(){}.getType());
    }

    @Override
    public String getNextBrowserId() {
        return this.server.fetch(this.baseUrl + "/cmd?nextBrowserId");
    }

    private void sendCommand(String id, ResponseStream stream, String cmd, boolean uploadFiles) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("data", cmd);
        params.put("id", id);
        CommandTask task = this.commandTaskFactory.getCommandTask(stream, this.fileSet, this.baseUrl, this.server, params, uploadFiles);
        task.run();
    }

    @Override
    public void eval(String id, ResponseStream responseStream, String cmd) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(cmd);
        JsonCommand jsonCmd = new JsonCommand(JsonCommand.CommandType.EXECUTE, parameters);
        this.sendCommand(id, responseStream, this.gson.toJson(jsonCmd), false);
    }

    @Override
    public void runAllTests(String id, ResponseStream responseStream, boolean captureConsole) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(String.valueOf(captureConsole));
        parameters.add("false");
        parameters.add(this.debug != false ? "1" : "");
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RUNALLTESTS, parameters);
        this.sendCommand(id, responseStream, this.gson.toJson(cmd), true);
    }

    @Override
    public void reset(String id, ResponseStream responseStream) {
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RESET, Collections.<String>emptyList());
        this.sendCommand(id, responseStream, this.gson.toJson(cmd), false);
    }

    @Override
    public void runTests(String id, ResponseStream responseStream, List<String> tests, boolean captureConsole) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(this.gson.toJson(tests));
        parameters.add(String.valueOf(captureConsole));
        parameters.add(this.debug != false ? "1" : "");
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RUNTESTS, parameters);
        this.sendCommand(id, responseStream, this.gson.toJson(cmd), true);
    }

    @Override
    public void dryRun(String id, ResponseStream responseStream) {
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.DRYRUN, Collections.<String>emptyList());
        this.sendCommand(id, responseStream, this.gson.toJson(cmd), true);
    }

    @Override
    public void dryRunFor(String id, ResponseStream responseStream, List<String> expressions) {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(this.gson.toJson(expressions));
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.DRYRUNFOR, parameters);
        this.sendCommand(id, responseStream, this.gson.toJson(cmd), true);
    }
}

