/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.Args4jFlagsParser;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.config.CmdFlags;
import com.google.jstestdriver.config.CmdLineFlagsFactory;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.DefaultConfiguration;
import com.google.jstestdriver.config.InitializeModule;
import com.google.jstestdriver.config.Initializer;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.guice.TestResultPrintingModule;
import com.google.jstestdriver.hooks.PluginInitializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogManager;
import org.kohsuke.args4j.CmdLineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsTestDriver {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriver.class);

    public static void main(String[] args) {
        try {
            CmdFlags cmdLineFlags = new CmdLineFlagsFactory().create(args);
            File basePath = cmdLineFlags.getBasePath();
            List<Plugin> cmdLinePlugins = cmdLineFlags.getPlugins();
            LogManager.getLogManager().readConfiguration(cmdLineFlags.getRunnerMode().getLogConfig());
            PluginLoader pluginLoader = new PluginLoader();
            List<Module> pluginModules = pluginLoader.load(cmdLinePlugins);
            LinkedList<Module> initializeModules = Lists.newLinkedList(pluginModules);
            Configuration configuration = JsTestDriver.getConfiguration(cmdLineFlags.getConfigPath());
            initializeModules.add(new InitializeModule(pluginLoader, basePath, new Args4jFlagsParser(), cmdLineFlags.getRunnerMode()));
            initializeModules.add(new Module(){

                public void configure(Binder binder) {
                    Multibinder.newSetBinder(binder, PluginInitializer.class).addBinding().to(TestResultPrintingModule.TestResultPrintingInitializer.class);
                }
            });
            Injector initializeInjector = Guice.createInjector(initializeModules);
            List<Module> actionRunnerModules = initializeInjector.getInstance(Initializer.class).initialize(pluginModules, configuration, cmdLineFlags.getRunnerMode(), cmdLineFlags.getUnusedFlagsAsArgs());
            Injector injector = Guice.createInjector(actionRunnerModules);
            injector.getInstance(ActionRunner.class).runActions();
            logger.info("Finished action run.");
        }
        catch (CmdLineException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (FailureException e) {
            System.out.println("Tests failed.");
            System.exit(1);
        }
        catch (Exception e) {
            logger.debug("Error {}", e);
            e.printStackTrace();
            System.out.println("Unexpected Runner Condition: " + e.getMessage() + "\n Use --runnerMode DEBUG for more information.");
            System.exit(1);
        }
    }

    public static Configuration getConfiguration(File config) throws FileNotFoundException {
        YamlParser configParser = new YamlParser();
        Configuration configuration = new DefaultConfiguration();
        if (config != null) {
            if (!config.exists()) {
                throw new RuntimeException("Config file doesn't exist: " + config.getAbsolutePath());
            }
            configuration = configParser.parse(new InputStreamReader((InputStream)new FileInputStream(config), Charset.defaultCharset()));
        }
        return configuration;
    }
}

