/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactoryModule;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.ConfigurationParser;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetProvider;
import com.google.jstestdriver.FlagsImpl;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.guice.BrowserActionProvider;
import com.google.jstestdriver.guice.FlagsModule;
import com.google.jstestdriver.html.HtmlDocModule;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEPluginActionBuilder {
    private final ConfigurationParser configParser;
    private final String serverAddress;
    private final ResponseStreamFactory responseStreamFactory;
    private List<String> tests = new LinkedList<String>();
    private final LinkedList<Module> modules = new LinkedList();
    private boolean reset = false;
    private List<String> dryRunFor = new LinkedList<String>();

    public IDEPluginActionBuilder(ConfigurationParser configParser, String serverAddress, ResponseStreamFactory responseStreamFactory) {
        this.configParser = configParser;
        this.serverAddress = serverAddress;
        this.responseStreamFactory = responseStreamFactory;
    }

    public IDEPluginActionBuilder addAllTests() {
        this.tests.add("all");
        return this;
    }

    public IDEPluginActionBuilder addTests(List<String> testCases) {
        this.tests.addAll(testCases);
        return this;
    }

    public IDEPluginActionBuilder dryRunFor(List<String> dryRunFor) {
        this.dryRunFor.addAll(dryRunFor);
        return this;
    }

    public IDEPluginActionBuilder resetBrowsers() {
        this.reset = true;
        return this;
    }

    public IDEPluginActionBuilder install(Module module) {
        this.modules.add(module);
        return this;
    }

    public ActionRunner build() {
        this.configParser.parse();
        this.modules.add(new HtmlDocModule());
        Injector injector = Guice.createInjector(new ActionFactoryModule(), new ConfigurationModule(this.modules, this.tests, this.reset, this.dryRunFor, this.serverAddress != null ? this.serverAddress : this.configParser.getServer(), this.configParser.getFilesList(), this.responseStreamFactory));
        return injector.getInstance(ActionRunner.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigurationModule
    extends AbstractModule {
        private final List<String> tests;
        private final boolean reset;
        private final List<String> dryRunFor;
        private final String serverAddress;
        private final Set<FileInfo> fileSet;
        private final ResponseStreamFactory responseStreamFactory;
        private final LinkedList<Module> modules;

        public ConfigurationModule(LinkedList<Module> modules, List<String> tests, boolean reset, List<String> dryRunFor, String serverAddress, Set<FileInfo> fileSet, ResponseStreamFactory responseStreamFactory) {
            this.modules = modules;
            this.tests = tests;
            this.reset = reset;
            this.dryRunFor = dryRunFor;
            this.serverAddress = serverAddress;
            this.fileSet = fileSet;
            this.responseStreamFactory = responseStreamFactory;
        }

        @Override
        protected void configure() {
            FlagsImpl flags = new FlagsImpl();
            flags.setTests(this.tests);
            flags.setReset(this.reset);
            flags.setDryRunFor(this.dryRunFor);
            this.install(new FlagsModule(flags));
            this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("originalFileSet")).toInstance(this.fileSet);
            this.bind(String.class).annotatedWith(Names.named("server")).toInstance(this.serverAddress);
            this.bind(Boolean.class).annotatedWith(Names.named("debug")).toInstance(Boolean.FALSE);
            this.bind(new TypeLiteral<List<Action>>(){}).toProvider(ActionListProvider.class);
            this.bind(ResponseStreamFactory.class).toInstance(this.responseStreamFactory);
            this.bind(new TypeLiteral<List<BrowserAction>>(){}).toProvider(BrowserActionProvider.class);
            this.bind(ExecutorService.class).toInstance(Executors.newCachedThreadPool());
            this.bind(Long.class).annotatedWith(Names.named("testSuiteTimeout")).toInstance(7200L);
            for (Module module : this.modules) {
                this.install(module);
            }
            this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("fileSet")).toProvider(FileSetProvider.class).in(Singleton.class);
        }
    }
}

