/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HomeServlet
extends HttpServlet {
    private static final long serialVersionUID = -5726088138365911141L;
    private final CapturedBrowsers capturedBrowsers;

    public HomeServlet(CapturedBrowsers capturedBrowsers) {
        this.capturedBrowsers = capturedBrowsers;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PrintWriter writer = resp.getWriter();
        if ("/".equals(req.getRequestURI())) {
            resp.setContentType("text/html");
            this.service(writer);
        }
    }

    public void service(PrintWriter writer) {
        writer.write("<html><head><title>JsTestDriver</title></head><body>");
        writer.write("<a href=\"/capture\">Capture This Browser</a><br/>");
        writer.write("<a href=\"/capture?strict\">Capture This Browser in strict mode</a><br/>");
        writer.write("<p><strong>Captured Browsers: (");
        writer.write(String.valueOf(this.capturedBrowsers.getSlaveBrowsers().size()));
        writer.write(")</strong></p>");
        for (SlaveBrowser browser : this.capturedBrowsers.getSlaveBrowsers()) {
            writer.write("<p>");
            BrowserInfo info = browser.getBrowserInfo();
            writer.write("Id: " + info.getId() + "<br/>");
            writer.write("Name: " + info.getName() + "<br/>");
            writer.write("Version: " + info.getVersion() + "<br/>");
            writer.write("Operating System: " + info.getOs() + "<br/>");
            if (browser.getCommandRunning() != null) {
                writer.write("Currently running " + browser.getCommandRunning() + "<br/>");
            } else {
                writer.write("Currently waiting...<br/>");
            }
            writer.write("</p>");
            writer.flush();
        }
        writer.write("</body></html>");
        writer.flush();
    }
}

