/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.ForwardingMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.servlet.ProxyServlet;

public class ForwardingServlet
extends ProxyServlet.Transparent {
    private static final int SKIP_FORWARD_INDEX = "/forward".length();
    private static final ThreadLocal<String> threadLocalReferrer = new ThreadLocal();
    private final ForwardingMapper forwardingMapper;

    public ForwardingServlet(ForwardingMapper forwardingMapper, String defaultServer, int port) {
        super("forward", defaultServer, port);
        this.forwardingMapper = forwardingMapper;
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        try {
            threadLocalReferrer.set(request.getHeader("Referer"));
            super.service(req, resp);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to forward " + request.getRequestURI(), e);
        }
        finally {
            threadLocalReferrer.remove();
        }
    }

    protected URL proxyHttpURL(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        return this.getForwardingUrl(scheme, serverName, serverPort, uri, threadLocalReferrer.get());
    }

    public URL getForwardingUrl(String scheme, String serverName, int serverPort, String uri, String referer) throws MalformedURLException {
        String forwardTo = this.forwardingMapper.getForwardTo(uri);
        if (forwardTo != null) {
            return new URL(forwardTo);
        }
        uri = uri.substring(SKIP_FORWARD_INDEX);
        if (referer != null && referer.startsWith("/forward")) {
            referer = referer.substring(SKIP_FORWARD_INDEX);
        }
        String incomingUrl = String.format("%s://%s:%d%s", scheme, serverName, serverPort, uri);
        URL refererUrl = new URL(referer);
        forwardTo = this.forwardingMapper.getForwardTo(refererUrl.getPath());
        if (forwardTo != null) {
            URL forwardUrl = new URL(forwardTo);
            StringBuilder sb = new StringBuilder();
            sb.append(forwardUrl.getProtocol());
            sb.append("://");
            sb.append(forwardUrl.getHost());
            int port = forwardUrl.getPort();
            if (port != -1) {
                sb.append(":");
                sb.append(Integer.toString(port));
            }
            String baseUrl = sb.toString();
            String finalUrl = baseUrl + uri;
            this.forwardingMapper.addForwardingMapping(incomingUrl, baseUrl);
            return new URL(finalUrl);
        }
        String baseUrl = this.forwardingMapper.getForwardTo(referer);
        this.forwardingMapper.addForwardingMapping(incomingUrl, baseUrl);
        return new URL(baseUrl + uri);
    }
}

