/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserCaptureEvent;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetCacheStrategy;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.Lock;
import com.google.jstestdriver.SlaveBrowser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetServlet
extends HttpServlet
implements Observer {
    private static final long serialVersionUID = -5224290018208979639L;
    private static final int HEARTBEAT_TIMEOUT = 2000;
    private final Gson gson = new Gson();
    private final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final CapturedBrowsers capturedBrowsers;
    private final FileSetCacheStrategy strategy = new FileSetCacheStrategy();
    private final FilesCache filesCache;

    public FileSetServlet(CapturedBrowsers capturedBrowsers, FilesCache filesCache) {
        this.capturedBrowsers = capturedBrowsers;
        this.filesCache = filesCache;
        this.capturedBrowsers.addObserver(this);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        String session = req.getParameter("session");
        String sessionId = req.getParameter("sessionId");
        if (session == null && sessionId != null) {
            this.sessionHeartBeat(id, sessionId);
        } else if (session.equals("start")) {
            this.startSession(id, resp.getWriter());
        } else if (session.equals("stop")) {
            this.stopSession(id, sessionId, resp.getWriter());
        }
    }

    private void sessionHeartBeat(String id, String sessionId) {
        Lock lock = this.locks.get(id);
        if (lock.getSessionId().equals(sessionId)) {
            lock.setLastHeartBeat(new Date().getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSession(String id, String sessionId, PrintWriter writer) {
        Lock lock = this.locks.get(id);
        try {
            lock.unlock(sessionId);
        }
        finally {
            writer.flush();
        }
    }

    public void startSession(String id, PrintWriter writer) {
        String sessionId;
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        Lock lock = this.locks.get(id);
        if (lock.tryLock(sessionId = UUID.randomUUID().toString())) {
            writer.write(sessionId);
        } else if (!browser.isCommandRunning() && browser.peekCommand() == null || new Date().getTime() - lock.getLastHeartBeat() > 2000L) {
            lock.forceUnlock();
            SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(id);
            slaveBrowser.clearCommandRunning();
            slaveBrowser.clearResponseQueue();
            this.filesCache.clear();
            writer.write(lock.tryLock(sessionId) ? sessionId : "FAILED");
        } else {
            writer.write("FAILED");
        }
        writer.flush();
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String data = req.getParameter("data");
        String id = req.getParameter("id");
        if (data != null) {
            this.uploadFiles(id, data);
        } else {
            this.checkFileSet(req.getParameter("fileSet"), id, resp.getWriter());
        }
    }

    public void checkFileSet(String fileSet, String browserId, PrintWriter writer) {
        SlaveBrowser browser;
        Set<FileInfo> browserFileSet;
        Collection clientFileSet = (Collection)this.gson.fromJson(fileSet, new TypeToken<Collection<FileInfo>>(){}.getType());
        Set<FileInfo> filesToRequest = this.strategy.createExpiredFileSet(clientFileSet, browserFileSet = (browser = this.capturedBrowsers.getBrowser(browserId)).getFileSet());
        if (!filesToRequest.isEmpty()) {
            if (browser.getBrowserInfo().getName().contains("Safari") || browser.getBrowserInfo().getName().contains("Opera") || browser.getBrowserInfo().getName().contains("Konqueror")) {
                filesToRequest.clear();
                for (FileInfo info : clientFileSet) {
                    filesToRequest.add(info);
                }
            }
            Set<FileInfo> filteredFilesToRequest = this.filterServeOnlyFiles(filesToRequest);
            writer.write(this.gson.toJson(filteredFilesToRequest));
        }
        writer.flush();
    }

    private Set<FileInfo> filterServeOnlyFiles(Set<FileInfo> filesToRequest) {
        LinkedHashSet<FileInfo> filteredFilesToRequest = new LinkedHashSet<FileInfo>();
        Set<String> cachedFiles = this.filesCache.getAllFileNames();
        for (FileInfo fileInfo : filesToRequest) {
            if (fileInfo.isServeOnly() && cachedFiles.contains(fileInfo.getFileName()) && this.filesCache.getFileInfo(fileInfo.getFileName()).getTimestamp() >= fileInfo.getTimestamp()) continue;
            filteredFilesToRequest.add(fileInfo);
        }
        return filteredFilesToRequest;
    }

    @Override
    public void update(Observable o, Object arg) {
        BrowserCaptureEvent captureEvent = (BrowserCaptureEvent)arg;
        if (captureEvent.event == BrowserCaptureEvent.Event.CONNECTED) {
            this.locks.put(captureEvent.getBrowser().getId(), new Lock());
        }
    }

    public void uploadFiles(String id, String data) {
        Collection filesData = (Collection)this.gson.fromJson(data, new TypeToken<Collection<FileInfo>>(){}.getType());
        for (FileInfo f : filesData) {
            String path = f.getFileName();
            this.filesCache.addFile(path, f);
        }
    }
}

