/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    private String file;
    private Long timestamp;
    private transient boolean isPatch;
    private boolean serveOnly;
    private List<FileInfo> patches;
    private String data;

    public String toString() {
        return "FileInfo [file=" + this.file + ", isPatch=" + this.isPatch + ", serveOnly=" + this.serveOnly + ", timestamp=" + this.timestamp + "]";
    }

    public String getData() {
        return this.data == null ? "" : this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public FileInfo() {
    }

    public FileInfo(String fileName, long timestamp, boolean isPatch, boolean serveOnly, String data) {
        this.file = fileName;
        this.timestamp = timestamp;
        this.isPatch = isPatch;
        this.serveOnly = serveOnly;
        this.data = data;
    }

    public List<FileInfo> getPatches() {
        if (this.patches != null) {
            return new LinkedList<FileInfo>(this.patches);
        }
        return new LinkedList<FileInfo>();
    }

    public void addPatch(FileInfo patch) {
        if (this.patches == null) {
            this.patches = new LinkedList<FileInfo>();
        }
        this.patches.add(patch);
    }

    public boolean isServeOnly() {
        return this.serveOnly;
    }

    public String getFileName() {
        return this.file;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    public boolean canLoad() {
        return !this.file.startsWith("http://") && !this.file.startsWith("https://");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.serveOnly ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        if (this.file == null && other.file != null) {
            return false;
        }
        if (!this.file.equals(other.file)) {
            return false;
        }
        return this.serveOnly == other.serveOnly;
    }
}

