/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.JsException;
import java.util.LinkedList;
import java.util.List;

public class FailureParser {
    private final Gson gson = new Gson();

    public Failure parse(String failure) {
        LinkedList<String> stack = new LinkedList<String>();
        String message = "";
        try {
            String[] lines;
            JsException exception = this.gson.fromJson(failure, JsException.class);
            message = exception.getMessage();
            String errorStack = exception.getStack();
            for (String l : lines = errorStack.split("\n")) {
                if (!l.contains("/test/")) continue;
                stack.add(l);
            }
        }
        catch (Exception e) {
            message = failure;
        }
        return new Failure(message, stack);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Failure {
        private final List<String> stack;
        private final String message;

        public Failure(String message, List<String> stack) {
            this.message = message;
            this.stack = stack;
        }

        public String getMessage() {
            return this.message;
        }

        public List<String> getStack() {
            return this.stack;
        }
    }
}

