/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import java.io.PrintStream;

public class EvalAction
implements BrowserAction {
    private final String cmd;
    private final ResponseStreamFactory responseStreamFactory;

    public EvalAction(ResponseStreamFactory responseStreamFactory, String cmd) {
        this.responseStreamFactory = responseStreamFactory;
        this.cmd = cmd;
    }

    public ResponseStream run(String id, JsTestDriverClient client) {
        ResponseStream responseStream = this.responseStreamFactory.getEvalActionResponseStream();
        client.eval(id, responseStream, this.getCmd());
        return responseStream;
    }

    public String getCmd() {
        return this.cmd;
    }

    public static class EvalActionResponseStream
    implements ResponseStream {
        private final PrintStream out;

        public EvalActionResponseStream(PrintStream out) {
            this.out = out;
        }

        public void finish() {
        }

        public void stream(Response response) {
            BrowserInfo browser = response.getBrowser();
            this.out.println(String.format("%s %s: %s", browser.getName(), browser.getVersion(), response.getResponse()));
        }
    }
}

