/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsActionResponseStream;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.output.TestResultListener;
import java.io.File;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseStreamFactory
implements ResponseStreamFactory {
    private final Provider<TestResultListener> responsePrinterFactory;
    private final FailureAccumulator accumulator;
    private final PrintStream out;
    private final File basePath;

    @Inject
    public DefaultResponseStreamFactory(Provider<TestResultListener> responsePrinterFactory, FailureAccumulator accumulator, @Named(value="outputStream") PrintStream out, @Named(value="basePath") File basePath) {
        this.responsePrinterFactory = responsePrinterFactory;
        this.accumulator = accumulator;
        this.out = out;
        this.basePath = basePath;
    }

    @Override
    public ResponseStream getRunTestsActionResponseStream(String browserId) {
        TestResultListener listener = this.responsePrinterFactory.get();
        RunTestsActionResponseStream responseStream = new RunTestsActionResponseStream(new TestResultGenerator(this.basePath), listener, this.accumulator);
        return responseStream;
    }

    @Override
    public ResponseStream getDryRunActionResponseStream() {
        return new DryRunAction.DryRunActionResponseStream(this.out);
    }

    @Override
    public ResponseStream getEvalActionResponseStream() {
        return new EvalAction.EvalActionResponseStream(this.out);
    }

    @Override
    public ResponseStream getResetActionResponseStream() {
        return new ResetAction.ResetActionResponseStream(this.out);
    }
}

