/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.ActionSequenceBuilder;
import com.google.jstestdriver.BrowserActionsRunner;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.hooks.ActionListProcessor;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultActionListProvider
implements ActionListProvider {
    private final ActionFactory actionFactory;
    private final FileLoader fileLoader;
    private final List<String> tests;
    private final List<String> arguments;
    private final boolean reset;
    private final List<String> dryRunFor;
    private final int port;
    private final boolean preloadFiles;
    private final Set<FileInfo> fileSet;
    private final String testOutput;
    private final ResponseStreamFactory responseStreamFactory;
    private final Provider<URLTranslator> urlTranslatorProvider;
    private final Provider<URLRewriter> urlRewriterProvider;
    private final FailureAccumulator accumulator;
    private final Set<ActionListProcessor> processors;
    private final XmlPrinter xmlPrinter;
    private final BrowserActionsRunner browserActionsRunner;

    @Inject
    public DefaultActionListProvider(ActionFactory actionFactory, FileLoader fileLoader, @Named(value="tests") List<String> tests, @Named(value="arguments") List<String> arguments, @Named(value="reset") boolean reset, @Named(value="dryRunFor") List<String> dryRunFor, @Named(value="preloadFiles") boolean preloadFiles, @Named(value="port") int port, @Named(value="fileSet") Set<FileInfo> fileSet, @Named(value="testOutput") String testOutput, ResponseStreamFactory responseStreamFactory, BrowserActionsRunner browserActionsRunner, Provider<URLTranslator> urlTranslatorProvider, Provider<URLRewriter> urlRewriterProvider, FailureAccumulator accumulator, Set<ActionListProcessor> processors, XmlPrinter xmlPrinter) {
        this.actionFactory = actionFactory;
        this.fileLoader = fileLoader;
        this.tests = tests;
        this.arguments = arguments;
        this.reset = reset;
        this.dryRunFor = dryRunFor;
        this.preloadFiles = preloadFiles;
        this.port = port;
        this.fileSet = fileSet;
        this.testOutput = testOutput;
        this.responseStreamFactory = responseStreamFactory;
        this.browserActionsRunner = browserActionsRunner;
        this.urlTranslatorProvider = urlTranslatorProvider;
        this.urlRewriterProvider = urlRewriterProvider;
        this.accumulator = accumulator;
        this.processors = processors;
        this.xmlPrinter = xmlPrinter;
    }

    @Override
    @Provides
    public List<Action> get() {
        ActionSequenceBuilder builder = new ActionSequenceBuilder(this.actionFactory, this.fileLoader, this.responseStreamFactory, this.browserActionsRunner, this.urlTranslatorProvider, this.urlRewriterProvider, this.accumulator);
        builder.usingFiles(this.fileSet, this.preloadFiles).addTests(this.tests).addCommands(this.arguments).reset(this.reset).asDryRunFor(this.dryRunFor).withLocalServerPort(this.port);
        if (this.testOutput.length() > 0) {
            builder.printingResultsWhenFinished(this.xmlPrinter);
        }
        List<Action> actions = builder.build();
        for (ActionListProcessor processor : this.processors) {
            actions = processor.process(actions);
        }
        return actions;
    }
}

