/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.HeartBeatManager;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.browser.BrowserPanicException;
import com.google.jstestdriver.util.StopWatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTask {
    private static final Logger logger = LoggerFactory.getLogger(CommandTask.class);
    private static final List<String> EMPTY_ARRAYLIST = new ArrayList<String>();
    private static final long WAIT_INTERVAL = 500L;
    public static final int CHUNK_SIZE = 50;
    private final Gson gson = new Gson();
    private final JsTestDriverFileFilter filter;
    private final ResponseStream stream;
    private final Set<FileInfo> fileSet;
    private final String baseUrl;
    private final Server server;
    private final Map<String, String> params;
    private final HeartBeatManager heartBeatManager;
    private final FileLoader fileLoader;
    private final boolean upload;
    private final StopWatch stopWatch;

    public CommandTask(JsTestDriverFileFilter filter, ResponseStream stream, Set<FileInfo> fileSet, String baseUrl, Server server, Map<String, String> params, HeartBeatManager heartBeatManager, FileLoader fileLoader, boolean upload, StopWatch stopWatch) {
        this.filter = filter;
        this.stream = stream;
        this.fileSet = fileSet;
        this.baseUrl = baseUrl;
        this.server = server;
        this.params = params;
        this.heartBeatManager = heartBeatManager;
        this.fileLoader = fileLoader;
        this.upload = upload;
        this.stopWatch = stopWatch;
    }

    private String startSession() {
        String browserId = this.params.get("id");
        String sessionId = this.server.startSession(this.baseUrl, browserId);
        if ("FAILED".equals(sessionId)) {
            while ("FAILED".equals(sessionId)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error("Could not create session for browser: " + browserId);
                    return "";
                }
                sessionId = this.server.startSession(this.baseUrl, browserId);
            }
        }
        return sessionId;
    }

    private void stopSession(String sessionId) {
        this.server.stopSession(this.baseUrl, this.params.get("id"), sessionId);
    }

    private void checkBrowser() {
        String alive = this.server.fetch(this.baseUrl + "/heartbeat?id=" + this.params.get("id"));
        if (!alive.equals("OK")) {
            throw new FailureException(String.format("Browser is not available\n {} \nfor\n {}", alive, this.params));
        }
    }

    public static FileSource fileInfoToFileSource(FileInfo info) {
        if (info.getFileName().startsWith("http://")) {
            return new FileSource(info.getFileName(), info.getTimestamp());
        }
        return new FileSource("/test/" + info.getFileName(), info.getTimestamp());
    }

    private void shouldPanic(Response response, String during) {
        if (response.getResponseType() == Response.ResponseType.BROWSER_PANIC) {
            BrowserPanic panic = (BrowserPanic)this.gson.fromJson(response.getResponse(), response.getResponseType().type);
            BrowserPanicException exception = new BrowserPanicException(panic.getBrowserInfo(), during);
            logger.error("Browser not found : {}\n during: {} \n Exception: {}", new Object[]{response.getResponse(), during, exception});
            throw exception;
        }
    }

    private void uploadFileSet() {
        LinkedHashMap<String, String> fileSetParams = new LinkedHashMap<String, String>();
        fileSetParams.put("id", this.params.get("id"));
        fileSetParams.put("fileSet", this.gson.toJson(this.fileSet));
        String postResult = this.server.post(this.baseUrl + "/fileSet", fileSetParams);
        if (postResult.length() > 0) {
            Collection filesToUpload = (Collection)this.gson.fromJson(postResult, new TypeToken<Collection<FileInfo>>(){}.getType());
            boolean shouldReset = this.sameFiles(filesToUpload, this.fileSet);
            LinkedHashSet<FileInfo> finalFilesToUpload = new LinkedHashSet<FileInfo>();
            if (shouldReset) {
                JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RESET, EMPTY_ARRAYLIST);
                LinkedHashMap<String, String> resetParams = new LinkedHashMap<String, String>();
                resetParams.put("id", this.params.get("id"));
                resetParams.put("data", this.gson.toJson(cmd));
                this.server.post(this.baseUrl + "/cmd", resetParams);
                logger.debug("Starting File Upload Refresh for {}", (Object)this.params.get("id"));
                String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + this.params.get("id"));
                StreamMessage message = this.gson.fromJson(jsonResponse, StreamMessage.class);
                Response response = message.getResponse();
                this.shouldPanic(response, "File upload reset");
                logger.debug("Finished File Upload Refresh for {}", (Object)this.params.get("id"));
                finalFilesToUpload.addAll(filesToUpload);
            } else {
                for (FileInfo file : filesToUpload) {
                    finalFilesToUpload.addAll(this.findDependencies(file));
                }
            }
            List<FileInfo> loadedfiles = this.fileLoader.loadFiles(finalFilesToUpload, shouldReset);
            LinkedHashMap<String, String> uploadFileParams = new LinkedHashMap<String, String>();
            uploadFileParams.put("id", this.params.get("id"));
            uploadFileParams.put("data", this.gson.toJson(loadedfiles));
            this.server.post(this.baseUrl + "/fileSet", uploadFileParams);
            LinkedList<FileSource> filesSrc = new LinkedList<FileSource>(this.filterFilesToLoad(loadedfiles));
            int numberOfFilesToLoad = filesSrc.size();
            for (int i = 0; i < numberOfFilesToLoad; i += 50) {
                int chunkEndIndex = Math.min(i + 50, numberOfFilesToLoad);
                LinkedList<String> loadParameters = new LinkedList<String>();
                List filesToLoad = filesSrc.subList(i, chunkEndIndex);
                loadParameters.add(this.gson.toJson(filesToLoad));
                loadParameters.add("false");
                JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.LOADTEST, loadParameters);
                LinkedHashMap<String, String> loadFileParams = new LinkedHashMap<String, String>();
                loadFileParams.put("id", this.params.get("id"));
                loadFileParams.put("data", this.gson.toJson(cmd));
                logger.debug("Sending LOADTEST for {}", (Object)this.params.get("id"));
                this.server.post(this.baseUrl + "/cmd", loadFileParams);
                String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + this.params.get("id"));
                StreamMessage message = this.gson.fromJson(jsonResponse, StreamMessage.class);
                Response response = message.getResponse();
                logger.debug("LOADTEST finished for ({}) {}", (Object)this.params.get("id"), (Object)response.getBrowser());
                this.shouldPanic(response, "Loading files into the browser.");
                this.stream.stream(response);
            }
        }
    }

    private Collection<FileInfo> findDependencies(FileInfo file) {
        LinkedList<FileInfo> deps = new LinkedList<FileInfo>();
        for (String fileName : this.filter.resolveFilesDeps(file.getFileName())) {
            deps.add(new FileInfo(fileName, new File(fileName).lastModified(), false, false, null));
        }
        return deps;
    }

    private List<FileSource> filterFilesToLoad(Collection<FileInfo> fileInfos) {
        LinkedList<FileSource> filteredFileSources = new LinkedList<FileSource>();
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.isServeOnly()) continue;
            filteredFileSources.add(CommandTask.fileInfoToFileSource(fileInfo));
        }
        return filteredFileSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.heartBeatManager.startTimer();
        String browserId = this.params.get("id");
        String sessionId = null;
        try {
            sessionId = this.startSession();
            if ("".equals(sessionId)) {
                throw new FailureException("Can't start a session on the server!" + this.params);
            }
            this.heartBeatManager.startHeartBeat(this.baseUrl, browserId, sessionId);
            this.checkBrowser();
            logger.debug("Starting upload for {}", (Object)browserId);
            if (this.upload) {
                this.stopWatch.start("upload", new Object[0]);
                this.uploadFileSet();
                this.stopWatch.stop("upload", new Object[0]);
            }
            logger.debug("Finished upload for {}", (Object)browserId);
            this.server.post(this.baseUrl + "/cmd", this.params);
            StreamMessage streamMessage = null;
            this.stopWatch.start("Command %s", this.params.get("data"));
            logger.debug("Starting {} for {}", (Object)this.params.get("data"), (Object)browserId);
            do {
                String response = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
                streamMessage = this.gson.fromJson(response, StreamMessage.class);
                Response resObj = streamMessage.getResponse();
                this.shouldPanic(resObj, "execution of command");
                this.stream.stream(resObj);
            } while (!streamMessage.isLast());
            this.stopWatch.stop("Command %s", this.params.get("data"));
        }
        finally {
            this.heartBeatManager.cancelTimer();
            this.stopSession(sessionId);
            logger.debug("finished {} for {}", (Object)this.params.get("data"), (Object)browserId);
        }
    }

    private boolean sameFiles(Collection<FileInfo> filesToUpload, Collection<FileInfo> fileSet) {
        for (FileInfo info : fileSet) {
            if (info.isServeOnly() || filesToUpload.contains(info)) continue;
            return false;
        }
        return true;
    }
}

