/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.BrowserPanic;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandServlet
extends HttpServlet {
    private static final long serialVersionUID = 7210927357890630427L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandServlet.class);
    private final Gson gson = new Gson();
    private final CapturedBrowsers capturedBrowsers;
    private final URLTranslator urlTranslator;
    private final URLRewriter urlRewriter;
    private final ForwardingMapper forwardingMapper;

    public CommandServlet(CapturedBrowsers browsers, URLTranslator urlTranslator, URLRewriter urlRewriter, ForwardingMapper forwardingMapper) {
        this.capturedBrowsers = browsers;
        this.urlTranslator = urlTranslator;
        this.urlRewriter = urlRewriter;
        this.forwardingMapper = forwardingMapper;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("listBrowsers") != null) {
            resp.getWriter().write(this.listBrowsers());
        } else if (req.getParameter("nextBrowserId") != null) {
            resp.getWriter().write(this.capturedBrowsers.getUniqueId());
        } else {
            this.streamResponse(req.getParameter("id"), resp.getWriter());
        }
        resp.getWriter().flush();
    }

    private SlaveBrowser.CommandResponse getResponse(SlaveBrowser browser) {
        SlaveBrowser.CommandResponse cmdResponse = null;
        while (cmdResponse == null) {
            if (!browser.isAlive()) {
                SlaveBrowser deadBrowser = this.capturedBrowsers.getBrowser(browser.getId());
                this.capturedBrowsers.removeSlave(browser.getId());
                Response response = new Response();
                response.setBrowser(deadBrowser.getBrowserInfo());
                response.setResponse(this.gson.toJson(new BrowserPanic(deadBrowser.getBrowserInfo())));
                response.setType(BrowserPanic.TYPE_NAME);
                return new SlaveBrowser.CommandResponse(response, true);
            }
            cmdResponse = browser.getResponse();
        }
        return cmdResponse;
    }

    private void substituteBrowserInfo(SlaveBrowser.CommandResponse cmdResponse) {
        Response response = cmdResponse.getResponse();
        SlaveBrowser slaveBrowser = this.capturedBrowsers.getBrowser(response.getBrowser().getId().toString());
        if (slaveBrowser != null) {
            response.setBrowser(slaveBrowser.getBrowserInfo());
        } else {
            BrowserInfo nullBrowserInfo = new BrowserInfo();
            nullBrowserInfo.setId(response.getBrowser().getId());
            nullBrowserInfo.setName("unknown browser");
            nullBrowserInfo.setVersion("unknown version");
            nullBrowserInfo.setOs("unknown os");
            response.setBrowser(nullBrowserInfo);
        }
        cmdResponse.setResponse(response);
    }

    public void streamResponse(String id, PrintWriter writer) {
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        SlaveBrowser.CommandResponse cmdResponse = this.getResponse(browser);
        this.substituteBrowserInfo(cmdResponse);
        StreamMessage response = new StreamMessage(cmdResponse.isLast(), cmdResponse.getResponse());
        writer.write(this.gson.toJson(response));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.service(req.getParameter("id"), req.getParameter("data"));
    }

    public String listBrowsers() {
        return this.gson.toJson(this.capturedBrowsers.getBrowsers());
    }

    public void service(String id, String data) {
        SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
        data = this.translateUrls(data);
        browser.createCommand(data);
    }

    private String translateUrls(String data) {
        JsonCommand command = this.gson.fromJson(data, JsonCommand.class);
        if (command.getCommand().equals(JsonCommand.CommandType.LOADTEST.getCommand())) {
            List<String> parameters = command.getParameters();
            String fileSourcesList = parameters.get(0);
            List fileSources = (List)this.gson.fromJson(fileSourcesList, new TypeToken<List<FileSource>>(){}.getType());
            for (FileSource fileSource : fileSources) {
                String fileSrc = fileSource.getFileSrc();
                if (!fileSrc.startsWith("http://") && !fileSrc.startsWith("https://")) continue;
                String url = this.urlRewriter.rewrite(fileSource.getFileSrc());
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    String translation = this.urlTranslator.getTranslation(url);
                    if (translation == null) {
                        try {
                            this.urlTranslator.translate(url);
                            translation = this.urlTranslator.getTranslation(url);
                            this.forwardingMapper.addForwardingMapping(translation, url);
                        }
                        catch (MalformedURLException e) {
                            LOGGER.warn("Could not translate URL: " + url + " fallback to default URL, things will probably start to act weird...", e);
                            translation = url;
                        }
                    }
                    fileSource.setBasePath(url);
                    fileSource.setFileSource(translation);
                    continue;
                }
                fileSource.setBasePath(url);
                fileSource.setFileSource(url);
            }
            parameters.remove(0);
            parameters.add(0, this.gson.toJson(fileSources));
            return this.gson.toJson(command);
        }
        return data;
    }
}

