/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Singleton;
import com.google.jstestdriver.BrowserCaptureEvent;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.SlaveBrowser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CapturedBrowsers
extends Observable {
    private final AtomicLong nextId = new AtomicLong(0L);
    private final Map<String, SlaveBrowser> slaves = new ConcurrentHashMap<String, SlaveBrowser>();

    public SlaveBrowser getBrowser(String id) {
        return this.slaves.get(id);
    }

    public String getUniqueId() {
        return Long.toString(this.nextId.incrementAndGet());
    }

    public void addSlave(SlaveBrowser slave) {
        this.slaves.put(slave.getId(), slave);
        this.setChanged();
        this.notifyObservers(new BrowserCaptureEvent(BrowserCaptureEvent.Event.CONNECTED, slave));
    }

    public Collection<SlaveBrowser> getSlaveBrowsers() {
        return this.slaves.values();
    }

    public List<BrowserInfo> getBrowsers() {
        ArrayList<BrowserInfo> browsersList = new ArrayList<BrowserInfo>();
        for (SlaveBrowser slave : this.getSlaveBrowsers()) {
            browsersList.add(slave.getBrowserInfo());
        }
        return browsersList;
    }

    public void removeSlave(String id) {
        SlaveBrowser slave = this.slaves.remove(id);
        this.setChanged();
        this.notifyObservers(new BrowserCaptureEvent(BrowserCaptureEvent.Event.DISCONNECTED, slave));
    }

    public String toString() {
        return String.format("CapturedBrowsers(%s)", this.slaves);
    }
}

