/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Action;
import com.google.jstestdriver.browser.BrowserRunner;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserStartupAction
implements Action,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(BrowserStartupAction.class);
    private final CountDownLatch latch;
    private final Set<BrowserRunner> browsers;
    private final String serverAddress;

    public BrowserStartupAction(Set<BrowserRunner> browsers, String serverAddress, CountDownLatch latch) {
        this.browsers = browsers;
        this.serverAddress = serverAddress;
        this.latch = latch;
    }

    @Override
    public void run() {
        try {
            String url = String.format("%s/capture", this.serverAddress);
            int timeout = 30;
            for (BrowserRunner browser : this.browsers) {
                browser.startBrowser(url);
                if (browser.getTimeout() <= timeout) continue;
                timeout = browser.getTimeout();
            }
            if (!this.latch.await(timeout, TimeUnit.SECONDS)) {
                long count = this.latch.getCount();
                if (count < (long)this.browsers.size()) {
                    logger.warn("Not all browsers were captured continuing anyway...");
                } else {
                    logger.error("None of the browsers were captured after 30 seconds");
                    for (BrowserRunner browser : this.browsers) {
                        browser.stopBrowser();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Error in starting browsers: {}", (Object)e.toString());
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.latch.countDown();
    }

    public Set<BrowserRunner> getBrowsers() {
        return this.browsers;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

