/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.Gson;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.Command;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.ForwardingMapper;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.LoadedFiles;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.protocol.BrowserStreamAcknowledged;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserQueryResponseServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(BrowserQueryResponseServlet.class);
    private static final long serialVersionUID = 995720234973219411L;
    private static final String NOOP = "noop";
    private final Gson gson = new Gson();
    private final CapturedBrowsers browsers;
    private final URLTranslator urlTranslator;
    private final ForwardingMapper forwardingMapper;
    private final ConcurrentMap<SlaveBrowser, List<String>> streamedResponses = new ConcurrentHashMap<SlaveBrowser, List<String>>();

    public BrowserQueryResponseServlet(CapturedBrowsers browsers, URLTranslator urlTranslator, ForwardingMapper forwardingMapper) {
        this.browsers = browsers;
        this.urlTranslator = urlTranslator;
        this.forwardingMapper = forwardingMapper;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.trace("Browser Query Post:\n\tpath:{}\n\tresponse:{}\n\tdone:{}\n\tresponseId:{}", new Object[]{req.getPathInfo().substring(1), req.getParameter("response"), req.getParameter("done"), req.getParameter("responseId")});
        this.service(req.getPathInfo().substring(1), req.getParameter("response"), req.getParameter("done"), req.getParameter("responseId"), resp.getWriter());
    }

    public void service(String id, String response, String done, String responseId, PrintWriter writer) {
        SlaveBrowser browser = this.browsers.getBrowser(id);
        if (browser != null) {
            boolean isLast = Boolean.parseBoolean(done);
            this.serviceBrowser(response, isLast, responseId, writer, browser);
        } else {
            logger.warn("Unknown browser {}", (Object)id);
        }
        writer.flush();
    }

    private void serviceBrowser(String response, Boolean done, String responseId, PrintWriter writer, SlaveBrowser browser) {
        this.addResponseId(responseId, browser);
        browser.heartBeat();
        Command command = null;
        if (this.isResponseValid(response) && browser.isCommandRunning()) {
            Response res = this.gson.fromJson(response, Response.class);
            switch (res.getResponseType()) {
                case FILE_LOAD_RESULT: {
                    LoadedFiles loadedFiles = (LoadedFiles)this.gson.fromJson(res.getResponse(), res.getGsonType());
                    Collection<FileResult> allLoadedFiles = loadedFiles.getLoadedFiles();
                    if (allLoadedFiles.isEmpty()) break;
                    LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
                    LinkedHashSet<FileSource> errorFiles = new LinkedHashSet<FileSource>();
                    for (FileResult fileResult : allLoadedFiles) {
                        FileSource fileSource = fileResult.getFileSource();
                        if (fileResult.isSuccess()) {
                            fileInfos.add(new FileInfo(fileSource.getBasePath(), fileSource.getTimestamp(), false, false, null));
                            continue;
                        }
                        errorFiles.add(fileSource);
                    }
                    browser.addFiles(fileInfos);
                    if (errorFiles.size() <= 0) break;
                    browser.removeFiles(errorFiles);
                    break;
                }
                case RESET_RESULT: {
                    JsonCommand jsonCommand;
                    Command commandRunning = browser.getCommandRunning();
                    if (commandRunning != null && (jsonCommand = this.gson.fromJson(commandRunning.getCommand(), JsonCommand.class)).getCommand().equals(JsonCommand.CommandType.RESET.getCommand())) {
                        command = browser.getLastDequeuedCommand();
                    }
                }
                case BROWSER_READY: {
                    browser.resetFileSet();
                    this.urlTranslator.clear();
                    this.forwardingMapper.clear();
                }
            }
            browser.addResponse(res, done);
        }
        if (this.isResponseIdValid(responseId) && !done.booleanValue() && !this.isResponseValid(response)) {
            logger.debug("Streaming query for ids {} from {}", this.streamedResponses.get(browser), (Object)browser);
        }
        if (!this.isResponseValid(response) && done.booleanValue() && browser.isCommandRunning()) {
            logger.error("Streaming ending, but no response sent for {} while running {}", browser, (Object)browser.getCommandRunning());
        }
        if (!done.booleanValue()) {
            writer.print(this.gson.toJson(new BrowserStreamAcknowledged((List)this.streamedResponses.get(browser))));
            writer.flush();
            return;
        }
        this.streamedResponses.clear();
        if (command == null) {
            command = browser.dequeueCommand();
        }
        writer.print(command != null ? command.getCommand() : NOOP);
    }

    private boolean isResponseValid(String response) {
        return response != null && !"null".equals(response) && response.length() > 0;
    }

    private void addResponseId(String responseId, SlaveBrowser browser) {
        if (!this.streamedResponses.containsKey(browser)) {
            this.streamedResponses.put(browser, new CopyOnWriteArrayList());
        }
        if (this.isResponseIdValid(responseId)) {
            return;
        }
        ((List)this.streamedResponses.get(browser)).add(responseId);
    }

    private boolean isResponseIdValid(String responseId) {
        return responseId == null || "".equals(responseId);
    }
}

