/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.TimeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserHunter {
    private static final Logger logger = LoggerFactory.getLogger(BrowserHunter.class.getName());
    private static final String REMOTE_CONSOLE_RUNNER = "/slave/%s/RemoteConsoleRunner%s.html";
    private final CapturedBrowsers capturedBrowsers;
    private final long browserTimeout;

    public BrowserHunter(CapturedBrowsers capturedBrowsers, long browserTimeout) {
        this.capturedBrowsers = capturedBrowsers;
        this.browserTimeout = browserTimeout;
    }

    public SlaveBrowser captureBrowser(String name, String version, String os) {
        return this.captureBrowser(this.capturedBrowsers.getUniqueId(), name, version, os);
    }

    public String getCaptureUrl(String id, String mode) {
        return String.format(REMOTE_CONSOLE_RUNNER, id, mode);
    }

    public SlaveBrowser captureBrowser(String rawId, String name, String version, String os) {
        BrowserInfo browserInfo = new BrowserInfo();
        Integer id = this.parseBrowserId(rawId);
        browserInfo.setId(id);
        browserInfo.setName(name);
        browserInfo.setVersion(version);
        browserInfo.setOs(os);
        SlaveBrowser slave = new SlaveBrowser(new TimeImpl(), id.toString(), browserInfo, this.browserTimeout);
        this.capturedBrowsers.addSlave(slave);
        logger.info("Browser Captured: {} version {} ({})", new Object[]{name, version, id});
        return slave;
    }

    private Integer parseBrowserId(String id) {
        if (id == null) {
            return Integer.parseInt(this.capturedBrowsers.getUniqueId());
        }
        return Integer.valueOf(id);
    }

    public boolean isBrowserCaptured(String id) {
        return this.capturedBrowsers.getBrowser(id) != null;
    }

    public void freeBrowser(String id) {
        this.capturedBrowsers.removeSlave(id);
    }
}

