/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.BrowserActionRunner;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.TestErrors;
import com.google.jstestdriver.browser.BrowserManagedRunner;
import com.google.jstestdriver.browser.BrowserRunner;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionsRunner
implements Action {
    private static final Logger logger = LoggerFactory.getLogger(BrowserActionsRunner.class);
    private final JsTestDriverClient client;
    private final List<BrowserAction> actions;
    private final ExecutorService executor;
    private final Set<BrowserRunner> browserRunners;
    private final String serverAddress;
    private final long testSuiteTimeout;

    @Inject
    public BrowserActionsRunner(JsTestDriverClient client, List<BrowserAction> actions, ExecutorService executor, Set<BrowserRunner> browserRunners, @Named(value="server") String serverAddress, @Named(value="testSuiteTimeout") long testTimeout) {
        this.client = client;
        this.actions = actions;
        this.executor = executor;
        this.browserRunners = browserRunners;
        this.serverAddress = serverAddress;
        this.testSuiteTimeout = testTimeout;
    }

    @Override
    public void run() {
        logger.trace("Starting BrowserActions {}.", this.actions);
        Collection<BrowserInfo> browsers = this.client.listBrowsers();
        if (browsers.size() == 0 && this.browserRunners.size() == 0 && this.actions.size() > 0) {
            throw new RuntimeException("No browsers available, yet actions requested. If running against a persistent server please capture browsers. Otherwise, ensure that browsers are defined.");
        }
        LinkedList<Callable<ResponseStream>> runners = Lists.newLinkedList();
        for (BrowserInfo browserInfo : browsers) {
            runners.add(new BrowserActionRunner(browserInfo.getId().toString(), this.client, this.actions));
        }
        for (BrowserRunner runner : this.browserRunners) {
            String browserId = this.client.getNextBrowserId();
            runners.add(new BrowserManagedRunner(runner, browserId, this.serverAddress, this.client, new BrowserActionRunner(browserId, this.client, this.actions)));
        }
        LinkedList<Throwable> exceptions = Lists.newLinkedList();
        LinkedList<ResponseStream> streams = Lists.newLinkedList();
        long currentTimeout = this.testSuiteTimeout;
        try {
            List results = this.executor.invokeAll(runners);
            for (Future result : results) {
                try {
                    streams.add((ResponseStream)result.get(currentTimeout, TimeUnit.SECONDS));
                }
                catch (ExecutionException e) {
                    exceptions.add(e.getCause());
                }
                catch (TimeoutException e) {
                    currentTimeout = 0L;
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.executor.shutdownNow();
        }
        logger.debug("Finished BrowserActions {}.", this.actions);
        if (!exceptions.isEmpty()) {
            throw new TestErrors("Failures during test run.", exceptions);
        }
        for (ResponseStream stream : streams) {
            stream.finish();
        }
    }

    public List<BrowserAction> getActions() {
        return this.actions;
    }

    public RunTestsAction getRunTestsAction() {
        for (BrowserAction action : this.actions) {
            if (!(action instanceof RunTestsAction)) continue;
            return (RunTestsAction)action;
        }
        return null;
    }

    public JsTestDriverClient getClient() {
        return this.client;
    }
}

