/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.jstestdriver.AggregatingResponseStreamFactory;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResponseStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActionRunner
implements Callable<ResponseStream> {
    private static final Logger logger = LoggerFactory.getLogger(BrowserActionRunner.class);
    private final String id;
    private final JsTestDriverClient client;
    private final List<BrowserAction> actions;

    public BrowserActionRunner(String id, JsTestDriverClient client, List<BrowserAction> actions) {
        this.id = id;
        this.client = client;
        this.actions = actions;
    }

    @Override
    public ResponseStream call() {
        LinkedList<ResponseStream> responseStreams = Lists.newLinkedList();
        for (BrowserAction action : this.actions) {
            logger.debug("Running BrowserAction {}", action);
            responseStreams.add(action.run(this.id, this.client));
        }
        return new AggregatingResponseStreamFactory.AggregatingResponseStream(responseStreams);
    }
}

