/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Provider;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.BrowserActionsRunner;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FailureCheckerAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.ServerShutdownAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.output.PrintXmlTestResultsAction;
import com.google.jstestdriver.output.XmlPrinter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSequenceBuilder {
    private final ActionFactory actionFactory;
    private final FileLoader fileLoader;
    private final Provider<URLTranslator> urlTranslatorProvider;
    private final Provider<URLRewriter> urlRewriterProvider;
    private final FailureAccumulator accumulator;
    private CapturedBrowsers capturedBrowsers = new CapturedBrowsers();
    private HashMap<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    private Set<FileInfo> fileSet;
    private int localServerPort = -1;
    private boolean preloadFiles = false;
    private boolean reset;
    private List<String> tests = new LinkedList<String>();
    private List<String> dryRunFor = new LinkedList<String>();
    private List<String> commands = new LinkedList<String>();
    private XmlPrinter xmlPrinter;
    private final BrowserActionsRunner browserActionsRunner;

    public ActionSequenceBuilder(ActionFactory actionFactory, FileLoader fileLoader, ResponseStreamFactory responseStreamFactory, BrowserActionsRunner browserActionsRunner, Provider<URLTranslator> urlTranslatorProvider, Provider<URLRewriter> urlRewriterProvider, FailureAccumulator accumulator) {
        this.actionFactory = actionFactory;
        this.fileLoader = fileLoader;
        this.browserActionsRunner = browserActionsRunner;
        this.urlTranslatorProvider = urlTranslatorProvider;
        this.urlRewriterProvider = urlRewriterProvider;
        this.accumulator = accumulator;
    }

    private void addServerActions(List<Action> actions, boolean leaveServerRunning) {
        if (this.preloadFiles) {
            for (FileInfo file : this.fileLoader.loadFiles(this.fileSet, true)) {
                this.files.put(file.getFileName(), file);
            }
        }
        ServerStartupAction serverStartupAction = this.actionFactory.getServerStartupAction(this.localServerPort, this.capturedBrowsers, new FilesCache(this.files), this.urlTranslatorProvider.get(), this.urlRewriterProvider.get());
        actions.add(0, serverStartupAction);
        if (!leaveServerRunning) {
            actions.add(new ServerShutdownAction(serverStartupAction));
        }
    }

    public ActionSequenceBuilder addTests(List<String> tests) {
        this.tests.addAll(tests);
        return this;
    }

    public ActionSequenceBuilder asDryRunFor(List<String> dryRunFor) {
        this.dryRunFor.addAll(dryRunFor);
        return this;
    }

    public List<Action> build() {
        LinkedList<Action> actions = new LinkedList<Action>();
        actions.add(this.browserActionsRunner);
        if (this.xmlPrinter != null) {
            actions.add(new PrintXmlTestResultsAction(this.xmlPrinter));
        }
        if (this.needToStartServer()) {
            this.addServerActions(actions, this.leaveServerRunning());
        }
        actions.add(new FailureCheckerAction(this.accumulator));
        return actions;
    }

    private boolean leaveServerRunning() {
        return this.tests.isEmpty() && this.commands.isEmpty() && !this.reset && this.dryRunFor.isEmpty();
    }

    private boolean needToStartServer() {
        return this.localServerPort != -1;
    }

    public ActionSequenceBuilder reset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public ActionSequenceBuilder usingFiles(Set<FileInfo> fileSet, boolean preloadFiles) {
        this.fileSet = fileSet;
        this.preloadFiles = preloadFiles;
        return this;
    }

    public ActionSequenceBuilder withLocalServerPort(int localServerPort) {
        this.localServerPort = localServerPort;
        return this;
    }

    public ActionSequenceBuilder addCommands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    public ActionSequenceBuilder printingResultsWhenFinished(XmlPrinter printer) {
        this.xmlPrinter = printer;
        return this;
    }
}

