/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.util.StopWatch;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRunner {
    private static final Logger stopWatchLogger = LoggerFactory.getLogger(StopWatch.class);
    private static final Logger logger = LoggerFactory.getLogger(ActionRunner.class);
    private final List<Action> actions;
    private final StopWatch stopWatch;

    @Inject
    public ActionRunner(List<Action> actions, StopWatch stopWatch) {
        this.actions = actions;
        this.stopWatch = stopWatch;
    }

    public void runActions() {
        for (Action action : this.actions) {
            this.stopWatch.start(action.toString(), new Object[0]);
            logger.info("Running {}", action);
            action.run();
            logger.info("Finished {}", action);
            this.stopWatch.stop(action.toString(), new Object[0]);
        }
        StringWriter writer = new StringWriter();
        this.stopWatch.print(writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        stopWatchLogger.info(((Object)writer).toString());
    }
}

