/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FilesCache;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.URLRewriter;
import com.google.jstestdriver.URLTranslator;
import com.google.jstestdriver.hooks.TestsPreProcessor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ActionFactory {
    Map<Class<?>, List<Observer>> observers = new HashMap();
    private final Provider<JsTestDriverClient> clientProvider;
    private final Set<TestsPreProcessor> testPreProcessors;
    private final long browserTimeout;

    @Inject
    public ActionFactory(Provider<JsTestDriverClient> clientProvider, Set<TestsPreProcessor> testPreProcessors, @Named(value="browserTimeout") long browserTimeout) {
        this.clientProvider = clientProvider;
        this.testPreProcessors = testPreProcessors;
        this.browserTimeout = browserTimeout;
    }

    public ServerStartupAction getServerStartupAction(Integer port, CapturedBrowsers capturedBrowsers, FilesCache preloadedFilesCache, URLTranslator urlTranslator, URLRewriter urlRewriter) {
        ServerStartupAction serverStartupAction = new ServerStartupAction(port, capturedBrowsers, preloadedFilesCache, urlTranslator, urlRewriter, this.browserTimeout);
        if (this.observers.containsKey(CapturedBrowsers.class)) {
            for (Observer o : this.observers.get(CapturedBrowsers.class)) {
                capturedBrowsers.addObserver(o);
            }
        }
        if (this.observers.containsKey(ServerStartupAction.class)) {
            serverStartupAction.addObservers(this.observers.get(ServerStartupAction.class));
        }
        return serverStartupAction;
    }

    public void registerListener(Class<?> clazz, Observer observer) {
        if (!this.observers.containsKey(clazz)) {
            this.observers.put(clazz, new LinkedList());
        }
        this.observers.get(clazz).add(observer);
    }

    public ResetAction createResetAction(ResponseStreamFactory responseStreamFactory) {
        return new ResetAction(responseStreamFactory);
    }

    public DryRunAction createDryRunAction(ResponseStreamFactory responseStreamFactory, List<String> expressions) {
        return new DryRunAction(responseStreamFactory, expressions);
    }

    public RunTestsAction createRunTestsAction(ResponseStreamFactory responseStreamFactory, List<String> tests, boolean captureConsole) {
        return new RunTestsAction(responseStreamFactory, tests, captureConsole, this.testPreProcessors);
    }

    public EvalAction createEvalAction(ResponseStreamFactory responseStreamFactory, String cmd) {
        return new EvalAction(responseStreamFactory, cmd);
    }

    public JsTestDriverClient getJsTestDriverClient(Set<FileInfo> filesList, String serverAddress) {
        return this.clientProvider.get();
    }
}

